/**
 * Bundle used to obtain an instance for i18n.
 */
class UIBundle {
	/**
	 * Class constructor.
	 *
	 * @param 	string  locale  The language locale.
	 */
	constructor(locale) {
		const path  = require('path');
		this.bundle = require('i18n-light');
	 	
	 	// configure bundle
		this.bundle.configure({
			defaultLocale: locale,
			dir: [__dirname, '..', '..', '..', 'locales'].join(path.sep),
			extension: '.json',
		});

		// directly return bundle
		return this.bundle;
	}

	/**
	 * Returns an instance of the bundle.
	 *
	 * @param 	string  locale  The language locale.
	 *
	 * @return 	object
	 */
	static getInstance(locale) {
		// use default one if not specified
		if (locale === undefined) {
			locale = 'en';
		}

		return new UIBundle(locale);
	}

	/**
	 * Checks whether the specified locale is supported.
	 *
	 * @return 	boolean
	 */
	static isSupported(locale) {
		const path = require('path');
		const fs   = require('fs');

		let file = [__dirname, '..', '..', '..', 'locales', locale + '.json'].join(path.sep);

		return fs.existsSync(file);
	}
}

// export for external usage
module.exports = UIBundle;
